/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRPotions;
import lotr.common.block.LOTRBlockCorruptMallorn;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIEntHealSapling;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityTree;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemEntDraught;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityEnt
extends LOTREntityTree {
    private Random branchRand = new Random();
    public int eyesClosed;
    public ChunkCoordinates saplingHealTarget;
    public boolean canHealSapling = true;

    public LOTREntityEnt(World world) {
        super(world);
        this.questInfo.setOfferChance(4000);
        this.questInfo.setMinAlignment(1000.0f);
        this.func_70105_a(1.4f, 4.6f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIEntHealSapling(this, 1.5));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 2.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 10.0f, 0.02f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.addTargetTasks(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public boolean isHealingSapling() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    public void setHealingSapling(boolean flag) {
        this.field_70180_af.func_75692_b(18, (Object)(flag ? (byte)1 : 0));
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getEntName(this.field_70146_Z));
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.ENT.createQuest(this);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(npcAttackDamageExtra).func_111128_a(1.0);
        this.func_110148_a(npcAttackDamage).func_111128_a(8.0);
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.FANGORN;
    }

    @Override
    public void func_70624_b(EntityLivingBase target) {
        super.func_70624_b(target);
        if (this.func_70638_az() == null) {
            this.canHealSapling = true;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.saplingHealTarget != null) {
            nbt.func_74768_a("SaplingHealX", this.saplingHealTarget.field_71574_a);
            nbt.func_74768_a("SaplingHealY", this.saplingHealTarget.field_71572_b);
            nbt.func_74768_a("SaplingHealZ", this.saplingHealTarget.field_71573_c);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("EntName")) {
            this.familyInfo.setName(nbt.func_74779_i("EntName"));
        }
        if (nbt.func_74764_b("SaplingHealX")) {
            int x = nbt.func_74762_e("SaplingHealX");
            int y = nbt.func_74762_e("SaplingHealY");
            int z = nbt.func_74762_e("SaplingHealZ");
            this.saplingHealTarget = new ChunkCoordinates(x, y, z);
        }
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    public int getExtraHeadBranches() {
        long l = this.func_110124_au().getLeastSignificantBits();
        l = l * 365620672396L ^ l * 12784892284L ^ l;
        l = l * l * 18569660L + l * 6639092L;
        this.branchRand.setSeed(l);
        if (this.branchRand.nextBoolean()) {
            return 0;
        }
        return MathHelper.func_76136_a((Random)this.branchRand, (int)2, (int)5);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.eyesClosed > 0) {
                --this.eyesClosed;
            } else if (this.field_70146_Z.nextInt(400) == 0) {
                this.eyesClosed = 30;
            }
            if (this.isHealingSapling()) {
                for (int l = 0; l < 2; ++l) {
                    float angle = this.field_70759_as + 90.0f + MathHelper.func_151240_a((Random)this.field_70146_Z, (float)-40.0f, (float)40.0f);
                    angle = (float)Math.toRadians(angle);
                    double d = this.field_70165_t + (double)MathHelper.func_76134_b((float)angle) * 1.5;
                    double d1 = this.field_70121_D.field_72338_b + (double)(this.field_70131_O * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.3f, (float)0.6f));
                    double d2 = this.field_70161_v + (double)MathHelper.func_76126_a((float)angle) * 1.5;
                    double d3 = (double)MathHelper.func_76134_b((float)angle) * 0.06;
                    double d4 = -0.03;
                    double d5 = (double)MathHelper.func_76126_a((float)angle) * 0.06;
                    LOTRMod.proxy.spawnParticle("leafGold_30", d, d1, d2, d3, d4, d5);
                }
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            List entities;
            float attackDamage = (float)this.func_110148_a(LOTREntityNPC.npcAttackDamage).func_111126_e();
            float knockbackModifier = 0.25f * attackDamage;
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockbackModifier * 0.5f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockbackModifier * 0.5f));
            this.field_70170_p.func_72956_a(entity, "lotr:ent.step", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            if (!this.field_70170_p.field_72995_K && !(entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, entity.field_70121_D.func_72314_b(4.0, 4.0, 4.0))).isEmpty()) {
                for (Object entitie : entities) {
                    float f;
                    EntityLivingBase hitEntity = (EntityLivingBase)entitie;
                    if (hitEntity == this || hitEntity == entity || !LOTRMod.canNPCAttackEntity(this, hitEntity, false)) continue;
                    float strength = 4.0f - entity.func_70032_d((Entity)hitEntity);
                    strength += 1.0f;
                    if (f > 4.0f) {
                        strength = 4.0f;
                    }
                    if (!hitEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), strength / 4.0f * attackDamage)) continue;
                    float knockback = strength * 0.25f;
                    if (knockback < 0.75f) {
                        knockback = 0.75f;
                    }
                    hitEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.2 + 0.12 * (double)knockback, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        boolean flag = super.func_70097_a(damagesource, f);
        if (!this.field_70170_p.field_72995_K && flag) {
            if (damagesource.func_76346_g() != null) {
                this.setHealingSapling(false);
            }
            if (this.func_70638_az() != null) {
                this.canHealSapling = false;
            }
        }
        return flag;
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (!this.field_70170_p.field_72995_K && damagesource.func_76346_g() instanceof EntityPlayer && this.saplingHealTarget != null) {
            int i = this.saplingHealTarget.field_71574_a;
            int j = this.saplingHealTarget.field_71572_b;
            int k = this.saplingHealTarget.field_71573_c;
            Block block = this.field_70170_p.func_147439_a(i, j, k);
            int meta = this.field_70170_p.func_72805_g(i, j, k);
            if (block == LOTRMod.corruptMallorn) {
                if (++meta >= LOTRBlockCorruptMallorn.ENT_KILLS) {
                    LOTRBlockCorruptMallorn.summonEntBoss(this.field_70170_p, i, j, k);
                } else {
                    this.field_70170_p.func_72921_c(i, j, k, meta, 3);
                }
            }
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killEnt;
    }

    @Override
    public float getAlignmentBonus() {
        return 3.0f;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        if (flag) {
            int dropChance = 10 - i * 2;
            if (dropChance < 1) {
                dropChance = 1;
            }
            if (this.field_70146_Z.nextInt(dropChance) == 0) {
                this.func_70099_a(new ItemStack(LOTRMod.entDraught, 1, this.field_70146_Z.nextInt(LOTRItemEntDraught.draughtTypes.length)), 0.0f);
            }
        }
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 5 + this.field_70146_Z.nextInt(6);
    }

    protected float func_70599_aP() {
        return 1.5f;
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
        this.func_85030_a("lotr:ent.step", 0.75f, this.func_70647_i());
    }

    @Override
    protected LOTRAchievement getTalkAchievement() {
        return LOTRAchievement.talkEnt;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            return "ent/ent/friendly";
        }
        return "ent/ent/hostile";
    }

    @Override
    public void func_70690_d(PotionEffect effect) {
        if (effect.func_76456_a() == Potion.field_82731_v.field_76415_H) {
            return;
        }
        if (effect.func_76456_a() == LOTRPotions.blood.field_76415_H) {
            return;
        }
        if (effect.func_76456_a() == LOTRPotions.infection.field_76415_H) {
            return;
        }
        if (effect.func_76456_a() == LOTRPotions.broken.field_76415_H) {
            return;
        }
        super.func_70690_d(effect);
    }

    @Override
    public boolean func_70692_ba() {
        return !this.isNPCPersistent && !this.hiredNPCInfo.isActive && !this.questInfo.anyActiveQuestPlayers();
    }
}

